<?php include('header.php'); ?>


<!-- heading -->

<section id="heading">
    <div class="headingmn">
        <div class="container">

            <div class="content">
                <span><?= $project->name ?></span>
                <h2><?= ucfirst($project->category) ?> <span>Project</span></h2>
                <p><?= $project->address ?></p>
            </div>

        </div>
    </div>
</section>



<!-- details -->
<section id="details">
    <div class="container">
        <div class="row">

            <div class="col-md-4">
                <div class="content">
                    <h4><?= $project->name ?></h4>
                    <p class="mb-2"><i class="fa-solid fa-location-dot"></i> <?= $project->address ?></p>
                    <p><i class="fa-solid fa-up-down-left-right"></i> <?= $project->area ?> </p>
                    <p class="mt-1"><i class="fa-solid fa-indian-rupee-sign"></i> <?= $project->price ?> </p>
                    <?php if($project->pdf != ''){ ?>
                    <a href="javascript:(0);" data-bs-toggle="modal" data-bs-target="#exampleModal1" target="_blank" style="display: inline-block; color: #fff; font-size: 21px; font-weight: 600; padding: 10px 30px; border-radius: 100px; margin-top: 15px; background: rgb(32 53 97); background: linear-gradient(90deg, rgb(32 53 97) 0%, rgb(74, 74, 74) 100%);">Download Brochure</a>
                    <?php } ?>
                </div>
            </div>

            <div class="col-md-8">
                <div class="description">
                    <h3>Description</h3>
                    <p><?= $project->description ?></p>
                </div>
            </div>

            <div class="col-12">
                <div class="wrapper">
                    <div class="image-gallery">
                        <aside class="thumbnails">
                            <a href="javascript:void(0);" class="thumbnail"
                                data-big="<?=base_url('assets/front/images/'.$project->featured_image);?>">
                                <div class="thumbnail-image"><img
                                        src="<?=base_url('assets/front/images/'.$project->featured_image);?>" alt="">
                                </div>
                            </a>
                            <?php foreach(json_decode($project->images) as $images) { ?>
                            <a href="javascript:void(0);" class="thumbnail"
                                data-big="<?=base_url('assets/front/images/'.$images);?>">
                                <div class="thumbnail-image"><img src="<?=base_url('assets/front/images/'.$images);?>" alt="">
                                </div>
                            </a>
                            <?php } ?>
                        </aside>
                        <main class="primary" style="background-image: url('<?=base_url('assets/front/images/'.$project->featured_image);?>'); background-size:contain;">
                        </main>
                    </div>
                </div>
            </div>

        </div>
        <h2>Features</h2>
        <ul class="list-unstyled">
            <?php $i = 0;
            foreach(json_decode($project->features) as $features) { 
            if($features != ""){ ?>
            <li><i class="fa-regular fa-circle-dot"></i> &nbsp;<?=$features?></li>
            <?php }} ?>
        </ul>

        <?php if($project->video != ''){ ?>
        <div class="map col-6">
            <h2>Youtube Video</h2>
            <iframe width="100%" height="350" src="https://www.youtube.com/embed/<?=$project->video?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        <?php } ?>
        <?php if($project->location != ''){ ?>
        <div class="map col-6">
            <h2>Project Location</h2>
            <iframe width="100%" height="350" style="border:0" loading="lazy" allowfullscreen referrerpolicy="no-referrer-when-downgrade" src="https://www.google.com/maps/embed/v1/place?key=AIzaSyA1_7xiAt3i12w4E3WH008QoTnK-CGw63M&q=<?=$project->location?>">
            </iframe>
        </div>
        <?php } ?>

    </div>
</section>


<!-- new-later -->

<section id="new-later">
    <div class="container">
        <div class="row">

            <div class="col-md-6">
                <div class="content">
                    <h2>Please fill out the form to schedule a site visit with us</h2>
                    <a href="javascript:(0);" data-bs-toggle="modal" data-bs-target="#exampleModal">Schedule a Site
                        Visit</a>
                </div>
            </div>

            <div class="col-md-6">
                <div class="imgsc">
                    <img src="<?=base_url('assets/front/images/bg-1.webp');?>" alt="">
                </div>
            </div>

        </div>
    </div>
</section>


<!-- Modal -->
<div class="modal fade" id="exampleModal1" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel"><?=sitename?></h1>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i
                        class="fa-solid fa-xmark"></i></button>
            </div>
            <div class="modal-body">

                <form class="row form" action="<?=base_url('home/enquiry');?>" method="post">
                    <input type="hidden" class="form-control" name="pdf" value="<?=base_url('assets/front/images/'.$project->pdf);?>">
                    <div class="mb-2 col-12">
                        <input type="name" class="form-control" name="name" id="validationDefault01" placeholder="Name"
                            required>
                    </div>

                    <div class="mb-2 col-md-6 p-1">
                        <div class="input-group">
                            <input type="email" class="form-control" id="validationDefaultUsername" name="email"
                                aria-describedby="inputGroupPrepend2" placeholder="Email" required>
                        </div>
                    </div>

                    <div class="mb-2 col-md-6 p-1">
                        <input type="tel" class="form-control" id="validationDefault02" name="phoneno"
                            placeholder="Phone No" required>
                    </div>

                    <div class="mb-2 col-12 ">
                        <div class="form-floating">
                            <textarea class="form-control" type="message" placeholder="Message" name="message"
                                id="floatingTextarea2" style="height: 80px"></textarea>
                        </div>
                    </div>

                    <div class=" col-12 text-center">
                        <button class="btn" type="submit">Let's Start</button>
                    </div>

                </form>

            </div>
        </div>
    </div>
</div>

<!-- footer -->

<?php include('footer.php'); ?>