<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin extends CI_Controller
{
	function __construct()
	{
		parent::__construct();

		// Load form validation ibrary & user model 
		$this->load->library('form_validation');
		$this->load->model('Admin_model');
		$this->load->model('Blog_model');

		// Admin login status 
		$this->isAdminLoggedIn = $this->session->userdata('isAdminLoggedIn');
		$this->Global = $this->Global_model->getdata();
		$this->load->helper(array('form', 'url'));
	}

	public function index()
	{
		if (isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/dashboard');
		} else {
			redirect('admin/login');
		}
	}
	public function dashboard()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$data['totalprojects'] = $this->db->query("Select * from project")->num_rows();
			$data['ongoingprojects'] = $this->db->query("Select * from project where category = 'ongoing'")->num_rows();
			$data['upcomingprojects'] = $this->db->query("Select * from project where category = 'upcoming'")->num_rows();
			$data['completedprojects'] = $this->db->query("Select * from project where category = 'completed'")->num_rows();
			$data['todayappointment'] = $this->db->query("Select * from appointment where date >= CURDATE()")->num_rows();

			$data['projects'] = $this->Admin_model->getprojects();
			$this->load->view('admin/dashboard', $data);
		}
	}

	public function about()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$data['name'] = 'about';
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				} else {
					unset($data['image']);
				}
				unset($data["submit"]);
				$this->Global_model->editpage($data);
				redirect('admin/about');
			}
			$a = $this->Global_model->getpage("about");
			$data["pagecontent"] = $a[0];
			$this->load->view('admin/about', $data);
		}
	}
	public function career()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$data['name'] = 'career';
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				} else {
					unset($data['image']);
				}
				unset($data["submit"]);
				$this->Global_model->editpage($data);
				redirect('admin/career');
			}
			$a = $this->Global_model->getpage("career");
			$data["pagecontent"] = $a[0];
			$this->load->view('admin/career', $data);
		}
	}
	public function vision()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$data['name'] = 'vision';
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				} else {
					unset($data['image']);
				}
				unset($data["submit"]);
				$this->Global_model->editpage($data);
				redirect('admin/vision');
			}
			$a = $this->Global_model->getpage("vision");
			$data["pagecontent"] = $a[0];
			$this->load->view('admin/vision', $data);
		}
	}
	public function login()
	{
		if (isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/dashboard');
		} else {
			$data = array();
			// If login request submitted 
			if (isset($_POST['loginSubmit'])) {
				$this->form_validation->set_rules('email', 'Email', 'required|valid_email');
				$this->form_validation->set_rules('password', 'password', 'required');

				if ($this->form_validation->run() == true) {
					$con = array(
						'returnType' => 'single',
						'conditions' => array(
							'email' => $this->input->post('email'),
							'password' => sha1($this->input->post('password')),
						)
					);
					$checkLogin = $this->Admin_model->getRows($con);
					if ($checkLogin) {
						$this->session->set_userdata('isAdminLoggedIn', TRUE);
						$this->session->set_userdata('userId', $checkLogin['id']);
						redirect('admin/dashboard/');
					} else {
						$this->session->set_flashdata('error_msg', ' Wrong email or password, please try again.');
					}
				} else {
					$this->session->set_flashdata('error_msg', ' Please fill all the mandatory fields.');
				}
			}

			// Load view 
			$this->load->view('admin/sign-in', $data);
		}
	}
	public function logout()
	{
		$this->session->unset_userdata('isAdminLoggedIn');
		$this->session->unset_userdata('userId');
		$this->session->sess_destroy();
		redirect('admin/login');
	}
	public function forgot_password()
	{
		if (isset($_POST['email'])) {
			$email = $this->input->post('email');
			$findemail = $this->Admin_model->ForgotPassword($email);
			if ($findemail) {
				$this->Admin_model->sendpassword($findemail);
			} else {
				$this->session->set_flashdata('error_msg', ' Email not found!');
				redirect(base_url() . 'admin/login', 'refresh');
			}
		}
		$this->load->view('admin/forgot');
	}

	public function projects()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$data['projects'] = $this->Project_model->getdata();
			$this->load->view('admin/projects', $data);
		}
	}
	public function directors()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$data['directors'] = $this->Global_model->getdirectors();
			$this->load->view('admin/directors', $data);
		}
	}
	
	public function appointments()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$query = $this->db->query("Select * from appointment order by date desc");
			$data['appointments'] = $query->result_array();
			$this->load->view('admin/appointments', $data);
		}
	}
	public function ongoingprojects()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$data['projects'] = $this->Project_model->getdata('category', 'ongoing');
			$this->load->view('admin/projects', $data);
		}
	}
	public function completedprojects()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$data['projects'] = $this->Project_model->getdata('category', 'completed');
			$this->load->view('admin/projects', $data);
		}
	}
	public function upcomingprojects()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$data['projects'] = $this->Project_model->getdata('category', 'upcoming');
			$this->load->view('admin/projects', $data);
		}
	}

	public function addprojects()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$title = $_POST['name'];
				$table = "project";
				$field = "link";
				$data['link'] =  $this->create_slug($title, $table, $field);
				$image = $this->upload('image', '');
				$data['featured_image'] = $image['file_name'];
				
				if (!empty($_FILES['pdf']['name'])) {
					$image = $this->upload('pdf', '');
					$data['pdf'] = $image['file_name'];
				}
				
				
				$data['features'] = json_encode(explode(",", $_POST['features'][0]));
				unset($data["submit"]);
				$this->load->model('Project_model');
				$this->Admin_model->addproject($data);
			}
			$this->load->view('admin/add-project');
		}
	}
	public function adddirector()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$image = $this->upload('image', '');
				$data['image'] = $image['file_name'];
				unset($data["submit"]);
				$this->load->model('Project_model');
				$this->Admin_model->adddirector($data);
			}
			$this->load->view('admin/add-director');
		}
	}

	public function editproject($slug)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['featured_image']['name'])) {
					$image = $this->upload('featured_image', '');
					$data['featured_image'] = $image['file_name'];
				}
				
				if (!empty($_FILES['pdf']['name'])) {
					$image = $this->upload('pdf', '');
					$data['pdf'] = $image['file_name'];
				}
				$data['features'] = json_encode(explode(",", $_POST['features'][0]));
				unset($data['submit']);
				$this->Admin_model->editproject($data);
			}
			$this->load->model('Project_model');
			$project = $this->Project_model->getdata('link', $slug);
			$data['project'] = $project[0];
			$this->load->view('admin/edit-project', $data);
		}
	}
	public function editdirector($slug)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				}
				unset($data["submit"]);
				$this->Admin_model->editdirector($data);
			}
			$director = $this->Global_model->getdirectors('id', $slug);
			$data['director'] = $director[0];
			$this->load->view('admin/edit-director', $data);
		}
	}
	
	

	public function upload($file, $dir = '')
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$config['upload_path']          = FCPATH . 'assets/front/images' . $dir;
			$config['allowed_types']        = 'gif|jpg|png|jpeg|webp|svg|pdf';

			$this->load->library('upload', $config);

			$this->upload->initialize($config);
			if (!$this->upload->do_upload($file)) {
				$data['error_message'] =  $this->upload->display_errors();
				$this->session->set_flashdata('error_msg', $data['error_message']);
				redirect($_SERVER['HTTP_REFERER']);
			} else {
				return $this->upload->data();
			}
		}
	}

	public function create_slug($name, $table, $field)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			// Use this code to create a slug
			// $title = "My name is Vishwas Moorjani";
			// $table = "project";
			// $field = "link";
			// $a =  $this->create_slug($title, $table, $field);

			$slug = $name;
			$slug = url_title($name);
			$key = NULL;
			$value = NULL;
			$i = 0;
			$params = array();
			$params[$field] = $slug;

			if ($key) $params["$key !="] = $value;

			while ($this->db->from($table)->where($params)->get()->num_rows()) {
				if (!preg_match('/-{1}[0-9]+$/', $slug))
					$slug .= '-' . ++$i;
				else
					$slug = preg_replace('/[0-9]+$/', ++$i, $slug);
				$params[$field] = $slug;
			}

			return strtolower($slug);
		}
	}

	public function create_qr($slug)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->library('ciqrcode');
			$params['data'] = base_url('project/') . $slug;
			$params['level'] = 'H';
			$params['size'] = 10;
			$name = $slug . '.png';
			$params['savename'] = FCPATH . 'assets/front/images/qr/' . $name;
			$this->ciqrcode->generate($params);
			return $name;
		}
	}

	public function activate($table = NULL, $link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->activate($table, $link);
			redirect($_SERVER['HTTP_REFERER']);
		}
	}
	public function deactivate($table = NULL, $link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->deactivate($table, $link);
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function delete($table = NULL, $link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->delete($table, $link);
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function removeimg($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removeimg('project', $link);
			echo ("done");
		}
	}
	public function removedirector($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removeimg('director', $link);
			echo ("done");
		}
	}
	public function removecatimg($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removecat('category', $link);
			echo ("done");
		}
	}
	public function removeabout()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->db->query("Update pages set image = NULL where name = 'about'");
			echo ("done");
		}
	}
	public function removecareer()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->db->query("Update pages set image = NULL where name = 'career'");
			echo ("done");
		}
	}
	public function removevision()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->db->query("Update pages set image = NULL where name = 'vision'");
			echo ("done");
		}
	}
	public function removeimage($link = NULL, $row = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$images = $this->Project_model->getimages($link);
			$target_value = $row;
			$a = "";
			$array = (json_decode($images->images));
			foreach ($array as $key => $value) {
				if ($value == $target_value) {
					unset($array[$key]);
				} else {
					$a = $a . json_encode($value) . ",";
				}
			}
			$a = "[" . (trim($a, ",")) . "]";
			$this->Project_model->saveimage($link, $a);
			redirect($_SERVER['HTTP_REFERER']);
		}
	}

	public function removeslider($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->Global_model->removeimg('slider', $link);
			echo ("done");
		}
	}

	public function removepdf($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removepdf('project', $link);
			echo ("done");
		}
	}

	public function sliders()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->Global['sliders'] = $this->Global_model->getslider();
			$this->load->view('admin/sliders', $this->Global);
		}
	}
	
		public function addslider()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$title = rand(100, 10000);
				$table = "slider";
				$field = "link";
				$slug =  $this->create_slug($title, $table, $field);
				$data = $_POST;
				$data['location'] = 'slider';
				$data['link'] = $slug;
				$image = $this->upload('image', '');
				$data['image'] = $image['file_name'];
				unset($data["submit"]);
				$this->Global_model->addslider($data);
			}
			$this->Global['sliders'] = $this->Global_model->getslider();
			$this->load->view('admin/add-slider', $this->Global);
		}
	}
	public function editslider($link)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				}
				unset($data["submit"]);
				$a = $this->Global_model->editgallery($data);
				redirect('admin/sliders');
			}
			$slider = $this->Global_model->getsliderimage($link);
			$this->Global['slider'] = $slider[0];
			$this->load->view('admin/edit-slider', $this->Global);
		}
	}

	public function gallery()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->Global['sliders'] = $this->Global_model->getgallery();
			$this->load->view('admin/gallery', $this->Global);
		}
	}

	public function addgallery()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$title = rand(100, 10000);
				$table = "slider";
				$field = "link";
				$slug =  $this->create_slug($title, $table, $field);
				$data = $_POST;
				$data['location'] = 'gallery';
				$data['link'] = $slug;
				$image = $this->upload('image', '');
				$data['image'] = $image['file_name'];
				unset($data["submit"]);
				$this->Global_model->addgallery($data);
			}
			$this->Global['sliders'] = $this->Global_model->getgallery();
			$this->load->view('admin/add-gallery', $this->Global);
		}
	}
	public function editgallery($link)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
					$data['image'] = $image['file_name'];
				}
				unset($data["submit"]);
				$a = $this->Global_model->editgallery($data);
				redirect('admin');
			}
			$slider = $this->Global_model->getgalleryimage($link);
			$this->Global['slider'] = $slider[0];
			$this->load->view('admin/edit-gallery', $this->Global);
		}
	}

	public function globalsettings()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->view('admin/globalsettings', $this->Global);
		}
	}

	public function editsettings()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$name = $_POST['name'];
				$value = $_POST['value'];
				$this->Global_model->editsettings($name, $value);
			}
			redirect('admin/globalsettings');
		}
	}

	public function change_password()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->view('admin/change-password');
		}
	}

	public function orders()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Orders_model');
			$data['orders'] = $this->Orders_model->getorders();
			$data['title'] = "All Order";
			$this->load->view('admin/orders', $data);
		}
	}

	public function addimages($link)
	{
		if (!empty($_FILES)) {
			// File upload configuration 
			$config['upload_path']          = FCPATH . 'assets/front/images';
			$config['allowed_types']        = 'gif|jpg|png|jpeg|webp|svg';

			// Load and initialize upload library 
			$this->load->library('upload', $config);
			$this->upload->initialize($config);

			// Upload file to the server 
			if ($this->upload->do_upload('file')) {
				$fileData = $this->upload->data();
				$this->load->model('Project_model');
				$images = $this->Project_model->getimages($link);
				$target_value = $fileData['file_name'];
				if ($images->images == "[]") {
					$a = trim($images->images, "]") . json_encode($target_value) . "]";
				} else {
					$a = (trim($images->images, "]") . "," . json_encode($target_value)) . "]";
				}
				$insert = $this->Project_model->saveimage($link, $a);
			}
		}
		$this->load->model('Project_model');
		$result = $this->Project_model->getimages($link);
		$data['link'] = $link;
		$data['images'] = json_decode($result->images, true);
		$this->load->view('admin/images', $data);
	}
	
	public function blogs()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$data['blogs'] = $this->Blog_model->getblogs();
			$this->load->view('admin/blogs', $data);
		}
	}
	public function addblog()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$title = $_POST['post_title'];
				$table = "blog";
				$field = "link";
				$data['link'] =  $this->create_slug($title, $table, $field);
				
				$image = $this->upload('image', '');
				$data['image'] = $image['file_name'];
				$blogger_image = $this->upload('blogger_image', '');
                $data['blogger_image'] = $blogger_image['file_name'];
				unset($data["submit"]);
				$this->Blog_model->addblog($data);
			}
			$this->load->view('admin/add-blog');
		}
	}
	public function editblog($slug)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
				    $data['image'] = $image['file_name'];
				}
				if (!empty($_FILES['blogger_image']['name'])) {
					$blogger_image = $this->upload('blogger_image', '');
                    $data['blogger_image'] = $blogger_image['file_name'];
				
				}
				unset($data["submit"]);
				$this->Blog_model->editpost($slug,$data);
				
			}
			$blog = $this->Blog_model->getblogs('link', $slug);
			$data['blog'] = $blog[0];
			$this->load->view('admin/edit-blog', $data);
		}
	}
	
	public function removeblog($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removeimg('blog', $link);
			echo ("done");
		}
	}
	public function removeblogger($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removecat('blog', $link);
			echo ("done");
		}
	}
	
	public function reviews()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$data['reviews'] = $this->Blog_model->getreviews();
			$this->load->view('admin/reviews', $data);
		}
	}
	public function addreview()
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				$image = $this->upload('image', '');
				$data['image'] = $image['file_name'];
				unset($data["submit"]);
				$this->Blog_model->addreview($data);
			}
			$this->load->view('admin/add-review');
		}
	}
	public function editreviews($slug)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			if (isset($_POST['submit'])) {
				$data = $_POST;
				if (!empty($_FILES['image']['name'])) {
					$image = $this->upload('image', '');
				    $data['image'] = $image['file_name'];
				}
				unset($data["submit"]);
				$this->Blog_model->editreview($slug,$data);
			}
			$review = $this->Blog_model->getreviews('id', $slug);
			$data['review'] = $review[0];
			$this->load->view('admin/edit-review', $data);
		}
	}
	public function removereviews($link = NULL)
	{
		if (!isset($_SESSION['isAdminLoggedIn'])) {
			redirect('admin/login');
		} else {
			$this->load->model('Project_model');
			$this->Project_model->removeimg('reviews', $link);
			echo ("done");
		}
	}
}
